//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create GENM CMP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_GENM_FILE "cmp_genm.bin"
#define CMP_RA_CERT   "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
//------------------------------------------------------------------------------
//        
// :
// 1.         CMP/GENM,  
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hExpKey;
 DWORD len,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //    ( )
 if (getFileLen(CMP_RA_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //    
 if (!CPGetUserKey(hProv,AT_SIGNATURE,&hKey)) {
   printf("CPGetUserKey AT_SIGNATURE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     CMP/GENM
 if (!CPGenKey(hProv,CALG_CMP_KEY,0,&hExpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  OID   CRL
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_GEN_OID,(BYTE*)CMP_GENERAL_CRL,0)) {
   printf("CPSetKeyParam KP_CMP_GEN_OID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_EXP_KEY,(BYTE*)&hKey,0)) {
   printf("CPSetKeyParam KP_CMP_EXP_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    ( )
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_RCP_SUBJ,Cert,0)) {
   printf("CPSetKeyParam KP_CMP_RCP_SUBJ Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,hKey,hExpKey,PUBLICKEYBLOB_CMP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_CMP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(CMP_GENM_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hExpKey);
 //
 //   
 if (!CPImportKey(hProv,WBuf,len,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  transactionID  
 len=sizeof(WBuf);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,WBuf,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 WBuf[len]=0;
 printf("transactionID = %s\n",(char*)WBuf);
 CPDestroyKey(hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
